﻿package com.kraftner.net 
{
	import JustLineOn;
	import com.adobe.images.JPGEncoder;
	import com.adobe.images.PNGEncoder;
	import flash.display.DisplayObject;
	import flash.display.BitmapData;
	import flash.events.IOErrorEvent;
	import flash.geom.Matrix;
	import flash.net.FileReference;
	import flash.utils.ByteArray;
	
	/**
	 * @internal
	 * SaveAs.as
	 * Copyright (c) 2008 Thomas Kräftner
	 * 
	 * Visit http://blog.kraftner.com for documentation, updates and more free code.
	 */
	
	/**
	* This class offers an easy way to export JPGs oder PNGs.
	* @author Thomas Kräftner
	*/
	public class SaveAs 
	{
		private static var myFileRef:FileReference = new FileReference();
		
		public function SaveAs() { }
		
		/**
		 * Export a DisplayObject as a JPG
		 * @param	dO DisplayObject to save
		 * @param	name Filename prefix. A timestamp is automatically added.
		 */
		public static function JPG(dO:DisplayObject, name:String = "Screenshot"):void
		{
			var bitmapData:BitmapData = new BitmapData(dO.width*JustLineOn.bmpMulti, dO.height*JustLineOn.bmpMulti, true);
			var matrix:Matrix = new Matrix();
			matrix.scale(JustLineOn.bmpMulti, JustLineOn.bmpMulti);
			bitmapData.draw(dO,matrix);
			var jpgEnc:JPGEncoder = new JPGEncoder(100);
			var JPEG:ByteArray = jpgEnc.encode(bitmapData);
			myFileRef.addEventListener(IOErrorEvent.IO_ERROR, error);
			myFileRef.save(JPEG, name + "_" + new Date().getTime() + ".jpg");
		}
		
		/**
		 * Export a DisplayObject as a PNG
		 * @param	dO DisplayObject to save
		 * @param	name Filename prefix. A timestamp is automatically added.
		 */
		public static function PNG(dO:DisplayObject, name:String = "Screenshot"):void
		{
			var bitmapData:BitmapData = new BitmapData(dO.width*JustLineOn.bmpMulti, dO.height*JustLineOn.bmpMulti, true);
			var matrix:Matrix = new Matrix();
			matrix.scale(JustLineOn.bmpMulti, JustLineOn.bmpMulti);
			bitmapData.draw(dO,matrix);
			var PNG:ByteArray = PNGEncoder.encode(bitmapData);
			myFileRef.addEventListener(IOErrorEvent.IO_ERROR, error);
			myFileRef.save(PNG, name + "_" + new Date().getTime() + ".png");
		}
		
		private static function error(e:IOErrorEvent):void
		{
			trace("file overwrite failed");
		}
		
	}
	
}