﻿package com.kraftner.justlineon.pointtransformers 
{
	import com.gskinner.utils.Rndm;
	import com.kraftner.communication.ControllerConnection;
	import com.kraftner.justlineon.Segment;
	
	/**
	 * @internal
	 * PointPlusRandom.as
	 * Copyright (c) 2008 Thomas Kräftner
	 * 
	 * Visit http://blog.kraftner.com for documentation, updates and more free code.
	 */
	
	/**
	* This PointTransformer changes the original coordinate as created by a LineServer in a certain range.
	* <p>If you want to add or substract a certain factor from the original set x1=x2 and/or y1=y2. This can be useful when moving the path from a PathPlayer class by a certain factor.</p>
	* @author Thomas Kräftner
	* @see com.kraftner.justlineon.lineservers.PathPlayer
	*/
	public class PointPlusRandom extends PointTransformer
	{
		private var x1:Number;
		private var x2:Number;
		private var y1:Number;
		private var y2:Number;
		
		/**
		 * @param	x1 Minimum to add to the original x-coordinate
		 * @param	x2 Maximum to add to the original x-coordinate
		 * @param	y1 Minimum to add to the original y-coordinate
		 * @param	y2 Maximum to add to the original y-coordinate
		 */
		public function PointPlusRandom(x1:Number,x2:Number,y1:Number,y2:Number) 
		{
			this.x1 = x1;
			this.x2 = x2;
			this.y1 = y1;
			this.y2 = y2;
			
			var controllerConnection:ControllerConnection = ControllerConnection.getInstance();
			controllerConnection.addRange("x1", setX1, -500, 500, x1);
			controllerConnection.addRange("x2", setX2, -500, 500, x2);
			controllerConnection.addRange("y1", setY1, -500, 500, y1);
			controllerConnection.addRange("y2", setY2, -500, 500, y2);
		}
		
		private function setX1(i:Number):void { x1 = i; }
		private function setX2(i:Number):void { x2 = i; }
		private function setY1(i:Number):void { y1 = i; }
		private function setY2(i:Number):void { y2 = i; }
		
		/**
		 * @inheritDoc
		 */
		override public function transform(s:Segment):Boolean {
			s.x += Rndm.float( x1, x2);
			s.y += Rndm.float( y1, y2);
			return false;
		}
		
	}
	
}