package  com.kraftner.justlineon.painters {
	
	import com.gskinner.utils.Rndm;
	import com.kraftner.communication.ControllerConnection;
	import com.kraftner.geom.Color;
	import com.kraftner.geom.DynamicPaletteHueCircle;
	import com.kraftner.geom.DynamicPaletteRandom;
	import com.kraftner.geom.Palette;
	import com.kraftner.geom.Palettes;
	import com.kraftner.geom.StaticPalette;
	import com.kraftner.justlineon.Segment;
	import flash.geom.Point;
	
	/**
	 * @internal
	 * RibbonPainter.as
	 * Copyright (c) 2008 Thomas Krftner
	 * 
	 * Visit http://blog.kraftner.com for documentation, updates and more free code.
	 */
	
	/**
	 * This Painter draws Ribbons with a wide range of options.
	 */
	public class RibbonPainter extends Painter  {
		
		private var twirl:Boolean;
		private var jumpeach:Boolean;
		private var multi:Number;
		private var min_widthDivisor:Number;
		private var max_widthDivisor:Number;
		private var maxJumpPerc:Number;
		private var border:Boolean;
		private var borderWidth:Number;
		
		private var borderPalette:Palette;
		
		/**
		 * 
		 * @param	multi Multiplicator for the width of the ribbon
		 * @param	twirl If true the ribbon twirls
		 * @param	jumpeach If true the color of the ribbon changes each Segment of a line
		 * @param	min_widthDivisor The width of the ribbon is relative to the length of the current segment. The minimum size of the ribbon is determined by this value. <p>Minimum width of ribbon = Length of Segment / this parameter</p>
		 * @param	max_widthDivisor The width of the ribbon is relative to the length of the current segment. The maximum size of the ribbon is determined by this value. <p>Maximum width of ribbon = Length of Segment / this parameter</p>
		 * @param	maxJumpPerc Maximal allowed difference of the width of the current Segment of the ribbon relative to the previous Segments width in Percent of the previous Segment.
		 * @param	border If true outlines are drawn. The first Color of the Palette of this Painter is used for the outline and therefore it isn't used for further drawing.
		 * @param	borderWidth Width of the outlines. Only used if border is true.
		 */	
		public function RibbonPainter(multi:Number, twirl:Boolean,jumpeach:Boolean,min_widthDivisor:Number,max_widthDivisor:Number,maxJumpPerc:Number, border:Boolean, borderWidth:Number)
		{
			this.multi = multi;
			this.twirl = twirl;
			this.jumpeach = jumpeach;
			this.min_widthDivisor = min_widthDivisor;
			this.max_widthDivisor = max_widthDivisor;
			this.maxJumpPerc = maxJumpPerc;
			this.border = border;
			this.borderWidth = borderWidth;
			
			var controllerConnection:ControllerConnection = ControllerConnection.getInstance();
			controllerConnection.addRange("multi", setMulti, 0, 300, multi);
			controllerConnection.addChoice("twirl", setTwirl, 2, uint(twirl));
			controllerConnection.addChoice("jumpeach", setJumpeach, 2, uint(jumpeach));
			controllerConnection.addRange("min_widthDivisor", setMinWidthDivisor, 0.3, 30, min_widthDivisor);
			controllerConnection.addRange("max_widthDivisor", setMaxWidthDivisor, 0.3, 30, max_widthDivisor);
			controllerConnection.addRange("maxJumpPerc", setMaxJumpPerc, 0, 100, maxJumpPerc);
			controllerConnection.addChoice("border", setBorder, 2, uint(border));
			controllerConnection.addRange("borderWidth", setBorderWidth, 0, 50, borderWidth);
		}
		
		private function setMulti(i:Number):void { multi = i; }
		private function setTwirl(i:Number):void { twirl = Boolean(i); }
		private function setJumpeach(i:Number):void { jumpeach = Boolean(i); }
		private function setMinWidthDivisor(i:Number):void { min_widthDivisor = i; }
		private function setMaxWidthDivisor(i:Number):void { max_widthDivisor = i; }
		private function setMaxJumpPerc(i:Number):void { maxJumpPerc = i; }
		private function setBorder(i:Number):void { border = Boolean(i); }
		private function setBorderWidth(i:Number):void { borderWidth = i; }
		
		override protected function init():void { }
		
		/**
		 * The Ribbon concentrates to one point at each end.
		 */
		override protected function drawStart(s:Segment):Boolean {
			
			if(!borderPalette && border) borderPalette = palettes.shift();
			
			for (var i:int = 0; i < palettes.length; i++) 
			{
				if (border && i==0) {
					drawRibbonEnd(s, 1 - (palettes.length/2)+i, (palettes.length/2) - i, palettes[i], true);
				}else if (border && i==palettes.length-1) {
					drawRibbonEnd(s, 1 - (palettes.length/2)+i, (palettes.length/2) - i, palettes[i], false, true);
				}else{
					drawRibbonEnd(s, 1 - (palettes.length/2)+i, (palettes.length/2) - i, palettes[i]);
				}
			}
			
			dump();
			
			var item:Palette;
            for each(item in palettes) {
				item.next();
			}
			if(border)borderPalette.next();

			return false;
		}
		
		/**
		 * The Ribbon concentrates to one point at each end.
		 */
		override protected function drawPrevStart(s:Segment):Boolean {
			
			if(!borderPalette && border) borderPalette = palettes.shift();
			
			for (var i:int = 0; i < palettes.length; i++) 
			{
				if (border && i==0) {
					drawRibbonStart(s, 1 - (palettes.length/2)+i, (palettes.length/2) - i, palettes[i], true);
				}else if (border && i==palettes.length-1) {
					drawRibbonStart(s, 1 - (palettes.length/2)+i, (palettes.length/2) - i, palettes[i], false, true);
				}else{
					drawRibbonStart(s, 1 - (palettes.length/2)+i, (palettes.length/2) - i, palettes[i]);
				}
			}
			
			if(jumpeach){
				var item:Palette;
				for each(item in palettes) {
					item.next();
				}
			}
			
			return false;
		}
		
		/**
		 * For each Palette in this Painter one Ribbon is painted. The width of the complete Ribbon is shared by all Ribbons.
		 */
		override protected function drawStandard(s:Segment):Boolean {
			
			if(!borderPalette && border) borderPalette = palettes.shift();
			
			for (var i:int = 0; i < palettes.length; i++) 
			{
				if (border && i==0) {
					drawRibbonSegment(s, 1 - (palettes.length/2)+i, (palettes.length/2) - i, palettes[i], true);
				}else if (border && i==palettes.length-1) {
					drawRibbonSegment(s, 1 - (palettes.length/2)+i, (palettes.length/2) - i, palettes[i], false, true);
				}else{
					drawRibbonSegment(s, 1 - (palettes.length/2)+i, (palettes.length/2) - i, palettes[i]);
				}
			}
			
			if(jumpeach){
				var item:Palette;
				for each(item in palettes) {
					item.next();
				}
			}
			
			return false;
		}
		
		private function drawRibbonSegment(s:Segment,offset1:Number=0,offset2:Number=0,palette:Palette=null,leftBorder:Boolean=false,rightBorder:Boolean=false):void
		{
			if (palette == null) palette = new DynamicPaletteRandom();
			
			var offsets:Array = getOffsets(s, offset1, offset2);
			
			var prevxoffset1:Number = offsets[0];
			var prevyoffset1:Number = offsets[1];
			var prevxoffset2:Number = offsets[2];
			var prevyoffset2:Number = offsets[3];
			
			var xoffset1:Number = offsets[4];
			var yoffset1:Number = offsets[5];
			var xoffset2:Number = offsets[6];
			var yoffset2:Number = offsets[7];
			
			canvas.graphics.beginFill(palette.current().hex, palette.current().a);
			
			canvas.graphics.moveTo(	s.prev_bisect_x + prevxoffset1,			s.prev_bisect_y + prevyoffset1);
			if (leftBorder) canvas.graphics.lineStyle(borderWidth, borderPalette.current().hex, borderPalette.current().a);
			canvas.graphics.curveTo(s.prev_x + (prevxoffset1+xoffset1)/2, 	s.prev_y+(prevyoffset1+yoffset1)/2,		s.bisect_x + xoffset1,			s.bisect_y+yoffset1);
			if (leftBorder) canvas.graphics.lineStyle();
			canvas.graphics.lineTo(	s.bisect_x + xoffset2, 					s.bisect_y+yoffset2);
			if (rightBorder) canvas.graphics.lineStyle(borderWidth, borderPalette.current().hex, borderPalette.current().a);
			canvas.graphics.curveTo(s.prev_x + (prevxoffset2+xoffset2)/2,	s.prev_y+(prevyoffset2+yoffset2)/2,		s.prev_bisect_x + prevxoffset2,	s.prev_bisect_y+prevyoffset2);
			if (rightBorder) canvas.graphics.lineStyle();
			canvas.graphics.lineTo(	s.prev_bisect_x + prevxoffset1,			s.prev_bisect_y+prevyoffset1);
			
			canvas.graphics.endFill();
			
		}
		
		private function drawRibbonEnd(s:Segment, offset1:Number = 0, offset2:Number = 0, palette:Palette = null,leftBorder:Boolean=false,rightBorder:Boolean=false):void
		{
			if (palette == null) palette = new DynamicPaletteRandom();
			
			var offsets:Array = getOffsets(s, offset1, offset2,true,false);
			
			var prevxoffset1:Number = offsets[0];
			var prevyoffset1:Number = offsets[1];
			var prevxoffset2:Number = offsets[2];
			var prevyoffset2:Number = offsets[3];
			
			canvas.graphics.beginFill(palette.current().hex, palette.current().a);
			
			canvas.graphics.moveTo(	s.prev_bisect_x + prevxoffset1,			s.prev_bisect_y + prevyoffset1);
			if (leftBorder) canvas.graphics.lineStyle(borderWidth, borderPalette.current().hex, borderPalette.current().a);
			canvas.graphics.lineTo(	s.prev_x, s.prev_y);
			if (leftBorder) canvas.graphics.lineStyle();
			if (rightBorder) canvas.graphics.lineStyle(borderWidth, borderPalette.current().hex, borderPalette.current().a);
			canvas.graphics.lineTo(	s.prev_bisect_x+prevxoffset2,			s.prev_bisect_y+prevyoffset2);
			if (rightBorder) canvas.graphics.lineStyle();
			canvas.graphics.endFill();
		}
		
		private function drawRibbonStart(s:Segment, offset1:Number = 0, offset2:Number = 0, palette:Palette = null,leftBorder:Boolean=false,rightBorder:Boolean=false):void
		{
			if (palette == null) palette = new DynamicPaletteRandom();
			
			var offsets:Array = getOffsets(s, offset1, offset2,false,true);
			
			var xoffset1:Number = offsets[4];
			var yoffset1:Number = offsets[5];
			var xoffset2:Number = offsets[6];
			var yoffset2:Number = offsets[7];
			
			canvas.graphics.beginFill(palette.current().hex, palette.current().a);
			canvas.graphics.moveTo(	s.prev_x, s.prev_y);
			if (leftBorder) canvas.graphics.lineStyle(borderWidth, borderPalette.current().hex, borderPalette.current().a);
			canvas.graphics.lineTo(	s.bisect_x + xoffset1, s.bisect_y + yoffset1);
			if (leftBorder) canvas.graphics.lineStyle();
			
			canvas.graphics.lineTo(	s.bisect_x + xoffset2, s.bisect_y + yoffset2);
			if (rightBorder) canvas.graphics.lineStyle(borderWidth, borderPalette.current().hex, borderPalette.current().a);
			canvas.graphics.lineTo(	s.prev_x, s.prev_y);
			if (rightBorder) canvas.graphics.lineStyle();
			canvas.graphics.endFill();
		}
		
		private function getOffsets(s:Segment, offset1:Number = 0, offset2:Number = 0, getPrev:Boolean=true, getCurrent:Boolean=true):Array
		{
			var prevxMulti:Number;
			var prevyMulti:Number;
			
			var min_width:Number = s.length / min_widthDivisor;
			var max_width:Number= s.length / max_widthDivisor;
			
			if(twirl){			
				var distance:Number;
				
				if(getPrev){
					distance = s.getPrevRibbonDistance();
					prevxMulti = (s.prev_rel_x / Math.abs(s.prev_rel_x)) * multi * distance;
					if (!prevxMulti) prevxMulti = 0;
					prevyMulti = (s.prev_rel_y / Math.abs(s.prev_rel_y)) * multi * distance;
					if (!prevyMulti) prevyMulti = 0;
				}else{
					prevxMulti = 0;
					prevyMulti = 0;
				}
				
				if(getCurrent){
					distance = s.getRibbonDistance(min_width,max_width, maxJumpPerc);
					xMulti = (s.rel_x / Math.abs(s.rel_x)) * multi * distance;
					if (!xMulti) xMulti = 0;
					yMulti = (s.rel_y / Math.abs(s.rel_y)) * multi * distance;			
					if (!yMulti) yMulti = 0;
				}else{
					xMulti = 0;
					yMulti = 0;
				}
			}else{
				var bisect_normalVector:Point;
				
				if(getPrev){
				bisect_normalVector = new Point( -s.prev_rel_y, s.prev_rel_x);
				bisect_normalVector.normalize(s.getPrevRibbonDistance() * multi);
				prevxMulti = bisect_normalVector.x;
				prevyMulti = bisect_normalVector.y;
				}else{
					prevxMulti = prevyMulti = 0;
				}
				
				if(getCurrent){
				bisect_normalVector = new Point(-s.rel_y, s.rel_x);
				bisect_normalVector.normalize(s.getRibbonDistance(min_width,max_width,maxJumpPerc) * multi);
				var xMulti:Number=bisect_normalVector.x;
				var yMulti:Number = bisect_normalVector.y;
				}else{
					xMulti = yMulti = 0;
				}
			}
			
			var prevxoffset1:Number = -prevxMulti+prevxMulti*offset1;
			var prevyoffset1:Number = -prevyMulti+prevyMulti*offset1;
			var prevxoffset2:Number = prevxMulti-prevxMulti*offset2;
			var prevyoffset2:Number = prevyMulti-prevyMulti*offset2;
			
			var xoffset1:Number = -xMulti+xMulti*offset1;
			var yoffset1:Number = -yMulti+yMulti*offset1;
			var xoffset2:Number = xMulti-xMulti*offset2;
			var yoffset2:Number = yMulti-yMulti*offset2;
			
			var offsets:Array = new Array(prevxoffset1,prevyoffset1,prevxoffset2,prevyoffset2,xoffset1,yoffset1,xoffset2,yoffset2);			
			return offsets;
		}
		
	}
}