package  com.kraftner.justlineon.painters {
	
	import com.kraftner.geom.Palette;
	import JustLineOn;
	import com.kraftner.justlineon.Segment;
	import flash.display.Sprite;
	import flash.display.Shape;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.geom.Matrix;
	import flash.utils.getQualifiedClassName;
	
	/**
	 * @internal
	 * Painter.as
	 * Copyright (c) 2008 Thomas Krftner
	 * 
	 * Visit http://blog.kraftner.com for documentation, updates and more free code.
	 */
	
	/**
	 * Template for all kinds of Painters
	 * <p>This Class defines the base functionality of all Painters. It only draws a grey line for each Segment. Therefore this Painter is ideal for debugging.</p>
	 * @author Thomas Krftner
	 */
	public class Painter extends Sprite  {
	
		/**
		 * BitmapData in which the drawn graphics are dumped to improve performance.
		 */
		protected var bitmapData:BitmapData = new BitmapData(JustLineOn.width*JustLineOn.bmpMulti,JustLineOn.height*JustLineOn.bmpMulti,true,0x00000000);
		/**
		 * Bitmap in which the drawn graphics are dumped to improve performance.
		 */
		protected var bitmap:Bitmap = new Bitmap(bitmapData);
		/**
		 * Shape in which the graphics are drawn.
		 */
		protected var canvas:Shape = new Shape();
		
		/**
		 * Stores the palettes this Painter uses
		 */
		protected var palettes:Vector.<Palette> = new Vector.<Palette>();
		
		/**
		 * Constructor method
		 */
		public function Painter():void
		{
			addChild(bitmap);
			bitmap.scaleX = bitmap.scaleY = 1/JustLineOn.bmpMulti;
			addChild(canvas);
			init();
		}
		
		/**
		 * Method that is called once when the Painter is instantiated. You may overwrite it in subclasses.
		 */
		protected function init():void
		{
			canvas.graphics.lineStyle(0, 0x888888);
		}
		
		/**
		 * Dumps the vector data from canvas to the Bitmap object
		 * @see #canvas
		 * @see #bitmapData
		 * @see #bitmap
		 */
		public function dump():void {
			if (JustLineOn.dump) {
				var matrix:Matrix = new Matrix();
				matrix.scale(JustLineOn.bmpMulti, JustLineOn.bmpMulti);
				bitmapData.draw(canvas,matrix);
				canvas.graphics.clear();
			}
		}
		
		/**
		 * Method that is called by a Lineserver. In most cases you don't need to overwrite this in subclasses. Use drawStart, drawPrevStart and drawStandard instead.
		 * @see com.kraftner.justlineon.lineservers.LineServer#step()
		 * @see #drawStart()
		 * @see #drawPrevStart()
		 * @see #drawStandard()
		 */
		public function draw(s:Segment):Boolean {
			var r:Boolean;
			if (s.start)
			{
				r=drawStart(s);
			}else if (s.prev_start){
				r=drawPrevStart(s);
			}else
			{
				r=drawStandard(s);
			}
			return r;
		}
		
		/**
		 * Method being called when the current Segment is a start-Segment
		 * @see com.kraftner.justlineon.Segment#start
		 */
		protected function drawStart(s:Segment):Boolean
		{
			dump();
			canvas.graphics.lineStyle(0, 0x888888);
			canvas.graphics.moveTo(s.x, s.y);
			return false;
		}
		
		/**
		 * Method being called when the previous Segment was a start-Segment
		 * @see com.kraftner.justlineon.Segment#start
		 */
		protected function drawPrevStart(s:Segment):Boolean
		{
			drawStandard(s);
			return false;
		}
		
		/**
		 * Method that handles a normal Segment
		 * @see #drawStart()
		 * @see #drawPrevStart()
		 * @see com.kraftner.justlineon.Segment#start
		 */
		protected function drawStandard(s:Segment):Boolean
		{
			canvas.graphics.moveTo(s.prev_x, s.prev_y);
			canvas.graphics.lineTo(s.x, s.y);
			return false;
		}
		
		/**
		 * Adds a Palette to this Painter
		 * @param	palette Palette to add to this Painter
		 * @see com.kraftner.geom.Palette
		 */
		public function addPalette(palette:Palette):void { palettes.push(palette); }
		
		public function destroy():void {
			bitmapData.dispose();
			bitmap = undefined;
		}
	}
}