﻿package com.kraftner.justlineon.painters 
{
	import com.gskinner.utils.Rndm;
	import com.kraftner.communication.ControllerConnection;
	import com.kraftner.geom.Palette;
	import com.kraftner.justlineon.Segment;
	
	/**
	 * @internal
	 * EndpointPainter.as
	 * Copyright (c) 2008 Thomas Kräftner
	 * 
	 * Visit http://blog.kraftner.com for documentation, updates and more free code.
	 */
	
	/**
	* This Painter draws basic geometric shapes at the end of each line.
	* @author Thomas Kräftner
	*/
	public class EndpointPainter extends Painter
	{
		
		private var form:Number;
		private var chance:Number;
		private var min_widthDivisor:Number;
		private var max_widthDivisor:Number;
		private var border:Boolean;
		private var borderWidth:Number;
		
		private var borderPalette:Palette;
		
		/**
		 * @param	form 0 draws circles, 1 draws squares
		 * @param	chance Chance that something is drawn. This Chance is represented by a Number between 0 and 1, 0 meaning that there's always something drawn and 1 meaning nothing is ever drawn.
		 * @param	min_widthDivisor The size of what is drawn relative to the length of the current segment. The minimum size is determined by this value. <p>Minimum width = Length of Segment / this parameter</p>
		 * @param	max_widthDivisor The size of what is drawn relative to the length of the current segment. The maximum size is determined by this value. <p>Maximum width = Length of Segment / this parameter</p>
		 * @param	border If true outlines are drawn. The first Color of the Palette of this Painter is used for the outline and therefore it isn't used for further drawing.
		 * @param	borderWidth Width of the outlines. Only used if border is true.
		 */
		public function EndpointPainter(form:Number,chance:Number,min_widthDivisor:Number,max_widthDivisor:Number, border:Boolean, borderWidth:Number) 
		{
			this.form = form;
			this.chance = chance;
			this.min_widthDivisor = min_widthDivisor;
			this.max_widthDivisor = max_widthDivisor;
			this.border = border;
			this.borderWidth = borderWidth;
			
			var controllerConnection:ControllerConnection = ControllerConnection.getInstance();
			controllerConnection.addChoice("form", setForm, 2, form);
			controllerConnection.addRange("chance", setChance, 0, 1, chance);
			controllerConnection.addRange("min_widthDivisor", setMinWidthDivisor, 0.3, 30, min_widthDivisor);
			controllerConnection.addRange("max_widthDivisor", setMaxWidthDivisor, 0.3, 30, max_widthDivisor);
			controllerConnection.addChoice("border", setBorder, 2, uint(border));
			controllerConnection.addRange("borderWidth", setBorderWidth, 0, 10, borderWidth);
		}
		
		private function setForm(i:Number):void {form = i; }
		private function setChance(i:Number):void { chance = i; }
		private function setMinWidthDivisor(i:Number):void { min_widthDivisor = i; }
		private function setMaxWidthDivisor(i:Number):void { max_widthDivisor = i; }
		private function setBorder(i:Number):void { border = Boolean(i); }
		private function setBorderWidth(i:Number):void { borderWidth = i; }
		
		override protected function init():void { }
		
		/**
		 * Drawing Routine
		 */
		override protected function drawStart(s:Segment):Boolean {
			
			if(!borderPalette && border) borderPalette = palettes.shift();
			
			dump();
			
			var min_width:Number = s.length / min_widthDivisor;
			var max_width:Number= s.length / max_widthDivisor;
			
			if (Rndm.boolean(chance))
			{
				var width:Number = Rndm.float(min_width, max_width);
				var item:Palette;
				for each(item in palettes) {
					canvas.graphics.beginFill(item.next().hex, item.current().a);
					if(border) canvas.graphics.lineStyle(borderWidth, borderPalette.next().hex, borderPalette.current().a);
					if (form == 0) {
						canvas.graphics.drawCircle(s.x-s.rel_x, s.y-s.rel_y, width/2);
					}else if(form==1) {
						canvas.graphics.drawRect(s.x-s.rel_x-width/2, s.y-s.rel_y-width/2, width, width);
					}
					if(border) canvas.graphics.lineStyle();
					canvas.graphics.endFill();
					width -= width / palettes.length;
				}
			}		
			
			return false;
		}
		
		/**
		 * Nothing is drawn at the Start of a Segment.
		 */
		override protected function drawPrevStart(s:Segment):Boolean {
			
			if (!borderPalette && border) borderPalette = palettes.shift();
			
			
			
			return false;
		}
		
		/**
		 * Nothing is drawn for normal Segments.
		 */
		override protected function drawStandard(s:Segment):Boolean {
			if(!borderPalette && border) borderPalette = palettes.shift();
			return false;
		}
		
	}
	
}