package  com.kraftner.justlineon.painters {
	
	import com.gskinner.utils.Rndm;
	import com.kraftner.communication.ControllerConnection;
	import com.kraftner.geom.Color;
	import com.kraftner.geom.DynamicPaletteHueCircle;
	import com.kraftner.geom.DynamicPaletteRandom;
	import com.kraftner.geom.Palette;
	import com.kraftner.geom.Palettes;
	import com.kraftner.geom.StaticPalette;
	import com.kraftner.justlineon.Segment;
	import flash.geom.Point;
	
	/**
	 * @internal
	 * DotPainter.as
	 * Copyright (c) 2008 Thomas Krftner
	 * 
	 * Visit http://blog.kraftner.com for documentation, updates and more free code.
	 */
	
	/**
	 * This Painter draws Circles on the line.
	 * @author Thomas Krftner
	 */
	public class DotPainter extends Painter  {
		
		private var chance:Number;
		private var min_widthDivisor:Number;
		private var max_widthDivisor:Number;
		private var border:Boolean;
		private var borderWidth:Number;
		
		private var borderPalette:Palette;
		
		/**
		 * @param	chance Chance that circle(s) is drawn. This Chance is represented by a Number between 0 and 1, 0 meaning that the circle(s) will never be drawn and 1 meaning it/they is/are always drawn.
		 * @param	min_widthDivisor The size of the circle(s) is relative to the length of the current segment. The minimum size of the circle(s) is determined by this value. <p>Minimum width of circle(s) = Length of Segment / this parameter</p>
		 * @param	max_widthDivisor The size of the circle(s) is relative to the length of the current segment. The maximum size of the circle(s) is determined by this value. <p>Maximum width of circle(s) = Length of Segment / this parameter</p>
		 * @param	border If true outlines are drawn. The first Color of the Palette of this Painter is used for the outline and therefore it isn't used for further drawing.
		 * @param	borderWidth Width of the outlines. Only used if border is true.
		 */
		public function DotPainter(chance:Number,min_widthDivisor:Number,max_widthDivisor:Number, border:Boolean, borderWidth:Number)
		{
			this.chance = chance;
			this.min_widthDivisor = min_widthDivisor;
			this.max_widthDivisor = max_widthDivisor;
			this.border = border;
			this.borderWidth = borderWidth;
			
			var controllerConnection:ControllerConnection = ControllerConnection.getInstance();
			controllerConnection.addRange("chance", setChance, 0, 1, chance);
			controllerConnection.addRange("min_widthDivisor", setMinWidthDivisor, 0.3, 30, min_widthDivisor);
			controllerConnection.addRange("max_widthDivisor", setMaxWidthDivisor, 0.3, 30, max_widthDivisor);
			controllerConnection.addChoice("border", setBorder, 2, uint(border));
			controllerConnection.addRange("borderWidth", setBorderWidth, 0, 10, borderWidth);
		}
		
		private function setChance(i:Number):void { chance = i; }
		private function setMinWidthDivisor(i:Number):void { min_widthDivisor = i; }
		private function setMaxWidthDivisor(i:Number):void { max_widthDivisor = i; }
		private function setBorder(i:Number):void { border = Boolean(i); }
		private function setBorderWidth(i:Number):void { borderWidth = i; }
		
		override protected function init():void { }
		
		/**
		 * Nothing is drawn at the End of a Segment but the current color of the palettes is changed.
		 */
		override protected function drawStart(s:Segment):Boolean {
			
			if(!borderPalette && border) borderPalette = palettes.shift();
			
			dump();
			
			if(border) borderPalette.next();		

			return false;
		}
		
		/**
		 * Nothing is drawn at the Start of a Segment.
		 */
		override protected function drawPrevStart(s:Segment):Boolean {
			if(!borderPalette && border) borderPalette = palettes.shift();
			
			return false;
		}
		
		/**
		 * Dot-drawing method
		 */
		override protected function drawStandard(s:Segment):Boolean {
			
			if(!borderPalette && border) borderPalette = palettes.shift();
			
			var min_width:Number = s.length / min_widthDivisor;
			var max_width:Number= s.length / max_widthDivisor;
			
			if (Rndm.boolean(chance))
			{
				var width:Number = Rndm.float(min_width, max_width);
				var item:Palette;
				for each(item in palettes) {
					canvas.graphics.beginFill(item.next().hex, item.current().a);
					if(border) canvas.graphics.lineStyle(borderWidth, borderPalette.current().hex, borderPalette.current().a);
					canvas.graphics.drawCircle(s.x, s.y, width);
					if(border) canvas.graphics.lineStyle();
					canvas.graphics.endFill();
					width -= width / palettes.length;
				}
			}
			return false;
		}
		
	}
}