﻿package com.kraftner.justlineon.lineservers 
{
	import com.gskinner.utils.Rndm;
	import com.kraftner.justlineon.AbortRule;
	import com.kraftner.justlineon.Segment;
	import flash.geom.Point;
	import JustLineOn;
	import com.kraftner.communication.ControllerConnection;
	import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.events.Event;
	
	/**
	 * @internal
	 * PathPlayer.as
	 * Copyright (c) 2008 Thomas Kräftner
	 * 
	 * Visit http://blog.kraftner.com for documentation, updates and more free code.
	 */
	
	/**
	* This LineServer loads a file which contains comma separated point-values on the format x1,y1,x2,y2,... <p>Due to the loading of an external file this LineServer deactivates itself during the loading process.
	* @author Thomas Kräftner
	*/
	public class PathPlayer extends LineServer
	{
		private var path:Vector.<Point> = new Vector.<Point>();
		
		private var restart:Boolean;
		
		/**
		 * @param	path Path to the file containing the coordinates
		 * @param	restart true means the path starts over when it reaches the end
		 */
		public function PathPlayer(path:String,restart:Boolean):void
		{
			killme = true;
			this.restart = restart;
			
			var loader:URLLoader = new URLLoader();
			var request:URLRequest = new URLRequest(path);
				
			var controllerConnection:ControllerConnection = ControllerConnection.getInstance();
			controllerConnection.addChoice("restart", setRestart, 2, uint(restart));
			
			loader.load(request);
			loader.addEventListener(Event.COMPLETE, onLoadComplete);
		}
		
		private function setRestart(i:Number):void {
			if(restart!=Boolean(i)){
				restart = Boolean(i);
				killme = false;
				counter = 0;
			}
		}
		
		private function onLoadComplete(event:Event):void 
		{
		var string:String = event.target.data;
		var coords:Array = string.split(",");
		for (var i:int = 0; i < coords.length-1; i+=2) 
		{
			path.push(new Point(coords[i],coords[i+1]));
		}
		path.push(new Point(coords[length-1], coords[length]));
		
		prev_Segment = new Segment(path[counter].x, path[counter].y, new Segment(path[counter].x, path[counter].y), true);
		killme = false;
		}
		
		/**
		 * @inheritDoc
		 */
		override protected function get newSegment():Segment
		{
			
			var newSegment:Segment = new Segment(path[counter].x, path[counter].y, prev_Segment);
			if (newSegment.x == 0 && newSegment.y == 0) {
				counter++;
				newSegment = new Segment(path[counter].x, path[counter].y, prev_Segment);
				newSegment.start = true;
			}
			
			
			if (counter + 1 >= path.length)
			{
				if (restart)
				{
					counter = 0;
					newSegment.start = true;	
				}else
				{
					counter = 0;
					newSegment.start = true;
					killme = true;
				}
			}
			return newSegment;
		}
		
	}
	
}