package  com.kraftner.justlineon.lineservers {
	
	import JustLineOn;
	import com.kraftner.justlineon.painters.Painter;
	import com.kraftner.justlineon.pointtransformers.PointTransformer;
	import com.kraftner.justlineon.Segment;
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.geom.Point;
	
	/**
	 * @internal
	 * LineServer.as
	 * Copyright (c) 2008 Thomas Krftner
	 * 
	 * Visit http://blog.kraftner.com for documentation, updates and more free code.
	 */
	
	/**
	 * Template for all kinds of LineServers
	 * <p>This Class defines the base functionality of all LineServers. It doesn't create any path on it's own but uses the mousePosition instead.</p>
	 * @author Thomas Krftner
	 */
	public class LineServer extends Sprite{
		
		private var pointTransformers:Vector.<PointTransformer> = new Vector.<PointTransformer>();
		private var painters:Vector.<Painter> = new Vector.<Painter>();
		
		protected var prev_Segment:Segment;
		
		protected var initial_x:Number=0;
		protected var initial_y:Number=0;
		protected var initial_rel_x:Number=0;
		protected var initial_rel_y:Number=0;
		protected var initial_length:Number=0;
		protected var initial_angle:Number=0;
		
		/**
		 * Counts the number of Segments already drawn
		 */
		protected var counter:uint = 0;
		
		/**
		 * Stores if this Lineserver is active or not.
		 * @see com.kraftner.justlineon.JustLineOn#step()
		 */
		protected var killme:Boolean = false;
		
		public function LineServer()
		{
			counter = 0;
			prev_Segment = new Segment(initial_x, initial_y);
		}
		
		/**
		 * This method defines the new Segment. It should be overwritten if you subclass your own LineServer.
		 */
		protected function get newSegment():Segment {
			var newSegment:Segment = new Segment(mouseX, mouseY, prev_Segment);
			return newSegment;
		}
		
		/**
		 * This method is called by the main application to trigger a new Segment.
		 * @see com.kraftner.justlineon.JustLineOn#step()
		 * @return true if this LineServer is deactivated
		 */
		public function step():Boolean {
			
			var segment:Segment = newSegment;
			
			for (var i:int = 0; i < pointTransformers.length; i++) 
			{
				if(pointTransformers[i].transform(segment)) killme=true;
			}
			for (var j:int = 0; j < painters.length; j++) 
			{
				if(painters[j].draw(segment)) killme=true;
			}
			
			prev_Segment = segment;
			
			counter++;
			return killme;
		}
		
		/**
		 * Adds a PointTransformer to this LineServer
		 * @param	pointTransformer PointTransformer to add to this LineServer
		 */
		public function addPointTransformer(pointTransformer:PointTransformer):void { pointTransformers.push(pointTransformer); }
		
		/**
		 * Adds a Painter to this LineServer
		 * @param	painter Painter to add to this LineServer
		 */
		public function addPainter(painter:Painter):void
		{
			addChild(painter);
			painters.push(painter);
		}
		
		/**
		 * Contains Code to be executed when this LineServer is destroyed. Use this to destroy all kinds of Listeners and other dependencies. Should be overwritten in Subclasses.
		 */
		public function destroy():void {
			for (var j:int = 0; j < painters.length; j++) 
			{
				painters[j].destroy();
			}
		}
		
		/**
		 * Dumps the content of all Painters in this LineServer to a Bitmap. This makes Vector export impossible but improves performance.
		 */
		public function dump():void
		{
			for (var j:int = 0; j < painters.length; j++) 
			{
				painters[j].dump();
			}
		}
		
		/**
		 * true if this LineServer is active
		 * @see #killme
		 */
		public function get isAlive():Boolean { return !killme; }
	}
}