﻿package com.kraftner.justlineon.lineservers 
{
	import com.gskinner.utils.Rndm;
	import com.kraftner.justlineon.AbortRule;
	import JustLineOn;
	import com.kraftner.justlineon.Segment;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.geom.Point;
	import com.kraftner.communication.ControllerConnection;
	
	/**
	 * @internal
	 * CircularExplosion.as
	 * Copyright (c) 2008 Thomas Kräftner
	 * 
	 * Visit http://blog.kraftner.com for documentation, updates and more free code.
	 */
	
	/**
	* This LineServer always starts from the center and moves until it hits the end of the stage or a certain distance from the center. Each new line starts some degree rotated relative to the former line. The distance is constantly decreased/increased so a spiral of lines is formed.
	* @author Thomas Kräftner
	* @see com.kraftner.justlineon.lineservers.CircularImplosion
	*/
	public class CircularExplosion extends LineServer
	{
		private var center:Point = JustLineOn.center;
		private var length:Number;
		private var angleMin:Number;
		private var angleMax:Number;
		private var away:Number;
		private var awaySub:Number;
		private var breakOutChance:Number;
		private var randomAbort:Number
		private var angle:Number = 0;
		private var circleStepWidth:Number;
		
		/**
		 * @param	length The average length of each line Segment. The actual length of a Segment varies between 60% and 140% of this value.
		 * @param	angleDegreeMin Minimum angle the new Segment turns away from the direction of the first Segment of this line.
		 * @param	angleDegreeMax Maximum angle the new Segment turns away from the direction of the first Segment of this line.
		 * @param	away Initital maximum distance the line can be away from the center. This only applies in connection with the next two parameters.
		 * @param	awaySub Factor which is substracted from away on each new line.
		 * @param	breakOutChance Chance the line ignores the away parameter and moves on. This Chance is represented by a Number between 0 and 1, 0 beeing impossible to break out. This chance isn't a one time decision but is triggered on each Segment of the line again.
		 * @param	randomAbort Chance the line randomly aborts. This Chance is represented by a Number between 0 and 1, 0 meaning the line never randomly aborts and 1 meaning it always aborts. If you set this parameter to 1 the line won't draw at all.
		 * @param	circleStepWidthDegree Number of degrees by which the next line starts offset from the previous angle.
		 */
		public function CircularExplosion(length:Number, angleDegreeMin:Number, angleDegreeMax:Number, away:Number, awaySub:Number, breakOutChance:Number, randomAbort:Number, circleStepWidthDegree:Number):void
		{
			this.length = length;
			this.angleMin = (Math.PI / 180) * angleDegreeMin;
			this.angleMax = (Math.PI / 180) * angleDegreeMax;
			this.away = away;
			this.awaySub = awaySub;
			this.breakOutChance = 1-breakOutChance;
			this.randomAbort = randomAbort;
			this.circleStepWidth = (Math.PI / 180) * circleStepWidthDegree;
			
			prev_Segment = new Segment(center.x + .01, center.y + .01, new Segment(center.x, center.y),true);
			prev_Segment.angle = angle;
			prev_Segment.length = .01;
			
			initial_x = center.x;
			initial_y = center.y;
			initial_angle = angle;
			
			var controllerConnection:ControllerConnection = ControllerConnection.getInstance();
			controllerConnection.addRange("length", setLength, 20, 150, length);
			controllerConnection.addRange("angleDegreeMin", setAngleDegreeMin, -360, 360, angleDegreeMin);
			controllerConnection.addRange("angleDegreeMax", setAngleDegreeMax, -360, 360, angleDegreeMax);
			controllerConnection.addRange("away", setAway, 1, 500, away);
			controllerConnection.addRange("awaySub", setAwaySub, 0, 10, awaySub);
			controllerConnection.addRange("breakOutChance", setBreakOutChance, 0, 1, breakOutChance);
			controllerConnection.addRange("randomAbort", setRandomAbort, 0, 1, randomAbort);
			controllerConnection.addRange("circleStepWidthDegree", setCircleStepWidthDegree, -360,360, circleStepWidthDegree);
		}
		
		private function setLength(i:Number):void { length=i; }
		private function setAngleDegreeMin(i:Number):void { angleMin = (Math.PI / 180) * i; }
		private function setAngleDegreeMax(i:Number):void { angleMax = (Math.PI / 180) * i; }
		private function setAway(i:Number):void { away = i; }
		private function setAwaySub(i:Number):void { awaySub = i; }
		private function setBreakOutChance(i:Number):void { breakOutChance = 1-i; }
		private function setRandomAbort(i:Number):void { randomAbort = i; }
		private function setCircleStepWidthDegree(i:Number):void { circleStepWidth = (Math.PI / 180) * i; }
		
		/**
		 * @inheritDoc
		 */
		override protected function get newSegment():Segment
		{
			var newSegment:Segment = new Segment(1, 1,prev_Segment);
			newSegment.angle = angle+Rndm.float(angleMin,angleMax);
			newSegment.length = length * Rndm.float(0.6, 1.4);
			
			if (Rndm.boolean(breakOutChance) && AbortRule.AwayFromCenter(new Point(newSegment.x,newSegment.y),away) || Rndm.boolean(0)|| Rndm.boolean(randomAbort) || AbortRule.OutOfStage(new Point(newSegment.x,newSegment.y)))
			{
				angle += circleStepWidth;
				newSegment = new Segment(initial_x, initial_y, prev_Segment, true);
			}
			away-=awaySub;
			return newSegment;
		}
		
	}
	
}