package  com.kraftner.justlineon {
	
	import com.gskinner.utils.Rndm;
	import flash.geom.Point;
	
	/**
	 * @internal
	 * Segment.as
	 * Copyright (c) 2008 Thomas Krftner
	 * 
	 * Visit http://blog.kraftner.com for documentation, updates and more free code.
	 */
	
	 /**
	  * This class represents one segment of a line in JustLineOn. It is passed through Lineserves, Pointtransformers and Painters.
	  * @author Thomas Krftner
	  * @see com.kraftner.justlineon.lineservers.LineServer
	  * @see com.kraftner.justlineon.pointtransformers.PointTransformer
	  * @see com.kraftner.justlineon.painters.Painter
	  */
	public class Segment {
		
		private var _x:Number;
		private var _y:Number;
		
		private var _rel_x:Number;
		private var _rel_y:Number;
		
		private var _bisect_x:Number;
		private var _bisect_y:Number;
		
		private var _length:Number;
		
		private var _angle:Number;
		
		private var _ribbon_distance:Number;
		
		/////////////////////////////////////////////////////////////////
		
		private var _prev_x:Number;
		private var _prev_y:Number;
		
		private var _prev_rel_x:Number;
		private var _prev_rel_y:Number;
		
		private var _prev_bisect_x:Number;
		private var _prev_bisect_y:Number;
		
		private var _prev_length:Number;
			
		private var _prev_angle:Number;
		
		private var _prev_ribbon_distance:Number;
		
		/////////////////////////////////////////////////////////////////
		
		private var _start:Boolean;
		private var _prev_start:Boolean;
		
		public function Segment(x:Number, y:Number, prevSegment:Segment=null, start:Boolean=false) {
			if (prevSegment == null)
			{
			_prev_x = 0;
			_prev_y = 0;
			_prev_rel_x = 0;
			_prev_rel_y = 0;
			_prev_bisect_x = 0;
			_prev_bisect_y = 0;
			_prev_length = 0;
			_prev_angle = 0;
			_prev_ribbon_distance = 1;
			_prev_start = false;
			}else{
			_prev_x = prevSegment.x;
			_prev_y = prevSegment.y;
			_prev_rel_x = prevSegment.rel_x;
			_prev_rel_y = prevSegment.rel_y;
			_prev_bisect_x = prevSegment.bisect_x;
			_prev_bisect_y = prevSegment.bisect_y;
			_prev_length = prevSegment.length;
			_prev_angle = prevSegment.angle;
			if (!prevSegment._ribbon_distance) prevSegment.getRibbonDistance(1,1);
			_prev_ribbon_distance = prevSegment._ribbon_distance;
			_prev_start = prevSegment.start;
			}
			this.start = start;
			this.x = x;
			this.y = y;
		}
		
		/**
		 * x-coordinate of the endpoint of this Segment
		 * @see #prev_x
		 */
		public function get x():Number { return _x; }
		/**
		 * @private
		 */
		public function set x(value:Number):void {
			_x = value;
			refresh_rel_x();
			refresh_length();
			refresh_angle();
			refresh_bisect_x();
		}
		
		/**
		 * y-coordinate of the endpoint of this Segment
		 * @see #prev_y
		 */
		public function get y():Number { return _y; }
		/**
		 * @private
		 */
		public function set y(value:Number):void {
			_y = value;
			refresh_rel_y();
			refresh_length();
			refresh_angle();
			refresh_bisect_y();
		}
		
		/**
		 * x value of the vector of this Segment. This is the difference between the x-coordinate of the endpoint and the startpoint of this Segment.
		 * @see #prev_rel_x
		 */
		public function get rel_x():Number { return _rel_x; }
		/**
		 * @private
		 */
		public function set rel_x(value:Number):void {
			_rel_x = value;
			_x = _prev_x + rel_x;
			refresh_length();
			refresh_angle();
			refresh_bisect_x();
		}
		private function refresh_rel_x():void { _rel_x = _x - _prev_x; }
		
		/**
		 * y value of the vector of this Segment. This is the difference between the y-coordinate of the endpoint and the startpoint of this Segment.
		 * @see #prev_rel_y
		 */
		public function get rel_y():Number { return _rel_y; }
		/**
		 * @private
		 */
		public function set rel_y(value:Number):void {
			_rel_y = value;
			_y = _prev_y + rel_y;
			refresh_length();
			refresh_angle();
			refresh_bisect_y();
		}
		private function refresh_rel_y():void { _rel_y = _y - _prev_y; }
		
		/**
		 * x value of the Bisection Point of this Segment. This is the x-coordinate of the point in the middle between the endpoint and the startpoint of this Segment.
		 * @see #prev_bisect_x
		 */
		public function get bisect_x():Number { return _bisect_x; }
		private function refresh_bisect_x():void { _bisect_x = Point.interpolate(new Point(x, y), new Point(prev_x, prev_y), .5).x; }
		
		/**
		 * y value of the Bisection Point of this Segment. This is the y-coordinate of the point in the middle between the endpoint and the startpoint of this Segment.
		 * @see #prev_bisect_x
		 */
		public function get bisect_y():Number { return _bisect_y; }
		private function refresh_bisect_y():void { _bisect_y = Point.interpolate(new Point(x, y), new Point(prev_x, prev_y), .5).y; }
		
		/**
		 * length of this Segment
		 * @see #prev_length
		 */
		public function get length():Number { return _length; }
		/**
		 * @private
		 */
		public function set length(value:Number):void {
			_length = value;
			var tempPoint:Point = new Point(_rel_x, _rel_y);
			tempPoint.normalize(_length);
			_x = _prev_x+tempPoint.x;
			_y = _prev_y + tempPoint.y;
			refresh_rel_x();
			refresh_rel_y();
			refresh_bisect_x();
			refresh_bisect_y();
		}
		private function refresh_length():void { _length = new Point(rel_x, rel_y).length; }
		
		/**
		 * angle of this Segment
		 * @see #prev_angle
		 */
		public function get angle():Number { return _angle; }
		public function set angle(value:Number):void {
			_angle = value;
			var tempPoint:Point = Point.polar(_length, _angle);
			_x = _prev_x + tempPoint.x;
			_y = _prev_y + tempPoint.y;
			refresh_rel_x();
			refresh_rel_y();
			refresh_bisect_x();
			refresh_bisect_y();
		}
		private function refresh_angle():void { _angle = Math.atan2(rel_y, rel_x); }
		
		/////////////////////////////////////////////////////////////////
		
		/**
		 * x-coordinate of the endpoint of the previous Segment which also is the startpoint of this segment.
		 * @see #x
		 */
		public function get prev_x():Number { return _prev_x; }
		/**
		 * y-coordinate of the endpoint of the previous Segment which also is the startpoint of this segment.
		 * @see #y
		 */
		public function get prev_y():Number { return _prev_y; }
		
		
		/**
		 * x value of the vector of the previous Segment. This is the difference between the x-coordinate of the endpoint and the startpoint of the previous Segment.
		 * @see #rel_x
		 */
		public function get prev_rel_x():Number { return _prev_rel_x; }
		/**
		 * y value of the vector of the previous Segment. This is the difference between the y-coordinate of the endpoint and the startpoint of the previous Segment.
		 * @see #rel_y
		 */
		public function get prev_rel_y():Number { return _prev_rel_y; }
		
		/**
		 * x value of the Bisection Point of the previous Segment. This is the x-coordinate of the point in the middle between the endpoint and the startpoint of the previous Segment.
		 * @see #bisect_x
		 */
		public function get prev_bisect_x():Number { return _prev_bisect_x; }
		/**
		 * y value of the Bisection Point of the previous Segment. This is the y-coordinate of the point in the middle between the endpoint and the startpoint of the previous Segment.
		 * @see #bisect_y
		 */
		public function get prev_bisect_y():Number { return _prev_bisect_y; }
		
		/**
		 * length of the previous segment
		 * @see #length
		 */
		public function get prev_length():Number { return _prev_length; }
		
		/**
		 * angle of the previous Segment
		 * @see #angle
		 */
		public function get prev_angle():Number { return _prev_angle; }
		
		/////////////////////////////////////////////////////////////////
		
		/**
		 * true if this is the first segment of a line
		 * @see #prev_start
		 */
		public function get start():Boolean { return _start; }
		/**
		 * @private
		 */
		public function set start(value:Boolean):void {	_start = value;	}
		
		/**
		 * true if the previous segment was the first segment of a line <p>(Except in the case the previous line had lust one Segment this means that this is the second segment of a line.)</p>
		 * @see #start
		 */
		public function get prev_start():Boolean { return _prev_start; }
		
		/////////////////////////////////////////////////////////////////
		
		/**
		 * This is only in use for the RibbonPainter. It defines the width of a ribbon being the distance from the original line.
		 * @param	min Minimum distance from the original line
		 * @param	max Maximum distance from the original line
		 * @param	maxJumpPerc Maximum difference between the distance of this Segment and the distance of the previous Segment
		 * @return distance from the original line
		 * @see com.kraftner.justlineon.painters.RibbonPainter
		 * @see #getPrevRibbonDistance()
		 */
		public function getRibbonDistance(min:Number = 1,max:Number=10,maxJumpPerc:Number=5):Number
		{
			if (!_ribbon_distance)
			{
				if (Math.abs(max - min) == 0)
				{
					_ribbon_distance = min;
				}else{
					_ribbon_distance = Rndm.float(min, max);
					var difference:Number = _ribbon_distance - _prev_ribbon_distance;
					if (Math.abs(difference) > Math.abs(max - min) * (maxJumpPerc / 100))
					{
						var prefix:Number = difference / Math.abs(difference);
						_ribbon_distance = _prev_ribbon_distance + prefix * Math.abs(max - min) * (maxJumpPerc / 100) ;
					}
				}
			}
			return _ribbon_distance;
		} 
		
		/**
		 * This is only in use for the RibbonPainter. It defines the width of a ribbon being the distance from the original line of the previous Segment.
		 * @return distance from the original line of the previous Segment
		 * @see com.kraftner.justlineon.painters.RibbonPainter
		 * @see #getRibbonDistance()
		 */
		public function getPrevRibbonDistance():Number { return _prev_ribbon_distance; }
	}
}