﻿package com.kraftner.justlineon 
{
	import flash.geom.Point;
	
	/**
	 * @internal
	 * AbortRule.as
	 * Copyright (c) 2008 Thomas Kräftner
	 * 
	 * Visit http://blog.kraftner.com for documentation, updates and more free code.
	 */
	
	/**
	* This class is a collection of rules to determine if a line should end at the Point where it is or not.
	* @author Thomas Kräftner
	* @see com.kraftner.justlineon.lineservers.Lineserver
	* @see com.kraftner.justlineon.pointtransformers.PointTransformer
	*/
	public class AbortRule 
	{
		
		public function AbortRule() {}
		
		/**
		 * Determines if the line has left the Stage or is a certain distance out of the Stage.
		 * @param	p Point to check
		 * @param	offset distance the Point can be out of the Stage
		 * @return
		 */
		public static function OutOfStage(p:Point,offset:Number=0):Boolean
		{
			if (p.x > JustLineOn.width+offset || p.y > JustLineOn.height+offset || p.x < 0-offset || p.y < 0-offset) return true;
			else return false;
		}
		
		/**
		 * Determines if the line is closer to the center of the Stage than a certain distance. Aborts if too far away.
		 * @param	p Point to check
		 * @param	distance maximum distance the Point should be away from the center of the Stage.
		 * @return
		 * @see #CloseToCenter()
		 */
		public static function AwayFromCenter(p:Point,distance:Number):Boolean
		{
			if (Point.distance(p, JustLineOn.center)>=distance) return true;
			else return false;
		}
		
		/**
		 * Determines if the line is closer to the center of the Stage than a certain distance. Aborts if too close.
		 * @param	p Point to check
		 * @param	distance minimum distance the Point should be away from the center of the Stage.
		 * @return
		 * @see #AwayFromCenter()
		 */
		public static function CloseToCenter(p:Point,distance:Number):Boolean
		{
			if (Point.distance(p, JustLineOn.center)<=distance) return true;
			else return false;
		}
		
	}
	
}