﻿package com.kraftner.geom 
{
	/**
	 * @internal
	 * StaticPalette.as
	 * Copyright (c) 2008 Thomas Kräftner
	 * 
	 * Visit http://blog.kraftner.com for documentation, updates and more free code.
	 */
	
	/**
	* Basic Palette which you can edit manually. In contrast to dynamic Palettes the Static Palette doesn't extend itself when out of Colors.
	* @author Thomas Kräftner
	* @see com.kraftner.geom.Palette#extend()
	*/
	public class StaticPalette extends Palette
	{
		/**
		 * Add a Color to this Palette
		 * @param	c Color to add to this Palette
		 * @see com.kraftner.geom.Color
		 */
		public function addColor(c:Color):void
		{
			palette.push(c);
		}
		
		/**
		 * Add a number of Colors representing a Gradient to this palette.
		 * @param	start Color to start the gradient with
		 * @param	end Color to end the gradient with
		 * @param	steps number of Colors the Gradient consists of
		 */
		public function addGradient(start:Color, end:Color, steps:uint = 10):void {
			
			var rstep:Number = ((end.r - start.r) / steps);
			var gstep:Number = ((end.g - start.g) / steps);
			var bstep:Number = ((end.b - start.b) / steps);
			var astep:Number = ((end.a - start.a) / steps);
			
			for (var i:Number = 0; i <= steps; i++) {
				palette.push(new Color(start.r+i*rstep,start.g+i*gstep,start.b+i*bstep,start.a+i*astep));
			}
		}
		
		/**
		 * Adds a number of Colors stored in HEX format in an Array
		 * @param	hex Array containing HEX values
		 */
		public function fillWithHex(hex:Array):void
		{
			for (var i:int = 0; i < hex.length; i++) 
			{
				var tempColor:Color = new Color();
				tempColor.hex = hex[i];
				palette.push(tempColor);
			}
		}
		
	}
	
}