﻿package com.kraftner.geom 
{
	/**
	 * @internal
	 * Palettes.as
	 * Copyright (c) 2008 Thomas Kräftner
	 * 
	 * Visit http://blog.kraftner.com for documentation, updates and more free code.
	 */
	
	/**
	* This Class is a collection of Palettes. Each Method returns a StaticPalette Object containing a set of 5 Color Objects.
	* @author Thomas Kräftner
	* @see com.kraftner.geom.Palette
	* @see com.kraftner.geom.StaticPalette
	* @see com.kraftner.geom.Color
	* @see http://www.colourlovers.com/blog/2007/06/20/color-inspiration-from-the-masters-of-painting/
	*/
	public class Palettes 
	{
		/**
		 * @see http://www.colourlovers.com/palette/85204/Mona_Lisa
		 */
		public static function get MonaLisa_LeonardodaVinci():StaticPalette
		{
			var palette:StaticPalette = new StaticPalette();
			palette.fillWithHex(new Array(0x000000, 0x303018, 0x606030, 0xC0A878, 0xF0C060));
			return palette;
		}
		
		/**
		 * @see http://www.colourlovers.com/palette/85213/PersistanceOfMemory
		 */
		public static function get PersistenceofMemory_SalvadorDali():StaticPalette
		{
			var palette:StaticPalette = new StaticPalette();
			palette.fillWithHex(new Array(0x784800, 0xD8D860, 0x60A8A8, 0x483000, 0x90C0A8));
			return palette;
		}
		
		/**
		 * @see http://www.colourlovers.com/palette/85232/Starry_Night
		 */
		public static function get StarryNight_VincentvanGogh():StaticPalette
		{
			var palette:StaticPalette = new StaticPalette();
			palette.fillWithHex(new Array(0x000000, 0x7890A8, 0x304878, 0x181848, 0xF0A818));
			return palette;
		}
		
		/**
		 * @see http://www.colourlovers.com/palette/85241/The_Birth_of_Venus
		 */
		public static function get TheBirthofVenus_SandroBotticelli():StaticPalette
		{
			var palette:StaticPalette = new StaticPalette();
			palette.fillWithHex(new Array(0x789090, 0x181800, 0x90A890, 0x181818, 0xE4E4C8));
			return palette;
		}
		
		/**
		 * @see http://www.colourlovers.com/palette/85245/Harmony_in_Red
		 */
		public static function get HarmonyinRed_HenriMatisee():StaticPalette
		{
			var palette:StaticPalette = new StaticPalette();
			palette.fillWithHex(new Array(0x600000, 0xD86018, 0x301830, 0xD80018, 0x306030));
			return palette;
		}
		
		/**
		 * @see http://www.colourlovers.com/palette/85251/Marilyn
		 */
		public static function get MarilynMonroe_AndyWarhol():StaticPalette
		{
			var palette:StaticPalette = new StaticPalette();
			palette.fillWithHex(new Array(0x3078A8, 0xD86090, 0x486048, 0xF0C048, 0xC04848));
			return palette;
		}
		
		/**
		 * @see http://www.colourlovers.com/palette/85378/The_Scream
		 */
		public static function get TheScream_EdvardMunch():StaticPalette
		{
			var palette:StaticPalette = new StaticPalette();
			palette.fillWithHex(new Array(0x0B110D, 0x2C4D56, 0xC3AA72, 0xDC7612, 0xBD3200));
			return palette;
		}
		
		/**
		 * @see http://www.colourlovers.com/palette/810/les_amants
		 */
		public static function get LesAmants_ReneMagritte():StaticPalette
		{
			var palette:StaticPalette = new StaticPalette();
			palette.fillWithHex(new Array(0x2E2623, 0xAC5251, 0xCBA990, 0x6A6869, 0x45484D));
			return palette;
		}
		
		/**
		 * @see http://www.colourlovers.com/palette/476275/A_Flock_of_Seagulls
		 */
		public static function get AFlockofSeagulls():StaticPalette
		{
			var palette:StaticPalette = new StaticPalette();
			palette.fillWithHex(new Array(0xFAFBFA, 0xF6F4F2, 0xEEF1EA, 0xF7F5EA, 0xF9F9F3));
			return palette;
		}
		
		public static function get BlackKnight():StaticPalette
		{
			var palette:StaticPalette = new StaticPalette();
			palette.fillWithHex(new Array(0x000000,0x141414,0x1C1919,0x1A1716,0x24201F));
			return palette;
		}
		
		/**
		 * This Color is special as it is 100% transparent. Use this if you only want to draw outlines.
		 */
		public static function get Ghost():StaticPalette
		{
			var palette:StaticPalette = new StaticPalette();
			palette.addColor(new Color(0, 0, 0, 0));
			return palette;
		}
		
	}
	
}