﻿package com.kraftner.geom 
{
	import com.kraftner.communication.ControllerConnection;
	
	/**
	 * @internal
	 * DynamicPaletteRandom.as
	 * Copyright (c) 2008 Thomas Kräftner
	 * 
	 * Visit http://blog.kraftner.com for documentation, updates and more free code.
	 */
	
	/**
	* Palette of totally randomly mixed Colors
	* @author Thomas Kräftner
	*/
	public class DynamicPaletteRandom extends Palette
	{
		
		private var randomize_red:Boolean;
		private var randomize_green:Boolean;
		private var randomize_blue:Boolean;
		private var randomize_alpha:Boolean;
		
		/**
		 * Constructor method. You can select which parts of the RGBA color should be randomized
		 * @param	randomize_red 
		 * @param	randomize_green
		 * @param	randomize_blue
		 * @param	randomize_alpha
		 * @param	fillWith precalculate a certain number of Colors
		 */
		public function DynamicPaletteRandom(randomize_red:Boolean = true,randomize_green:Boolean = true,randomize_blue:Boolean = true,randomize_alpha:Boolean=false,fillWith:Number=0):void
		{
			this.randomize_red = randomize_red;
			this.randomize_green = randomize_green;
			this.randomize_blue = randomize_blue;
			this.randomize_alpha = randomize_alpha;
			extend(fillWith);
			
			var controllerConnection:ControllerConnection = ControllerConnection.getInstance();
			controllerConnection.addChoice("randomize_red", setRandomizeRed, 2, uint(randomize_red));
			controllerConnection.addChoice("randomize_green", setRandomizeGreen, 2, uint(randomize_green));
			controllerConnection.addChoice("randomize_blue", setRandomizeBlue, 2, uint(randomize_blue));
			controllerConnection.addChoice("randomize_alpha", setRandomizeAlpha, 2, uint(randomize_alpha));
		}
		
		private function setRandomizeRed(i:Number):void { randomize_red = Boolean(i); }
		private function setRandomizeGreen(i:Number):void { randomize_green = Boolean(i); }
		private function setRandomizeBlue(i:Number):void { randomize_blue = Boolean(i); }
		private function setRandomizeAlpha(i:Number):void { randomize_alpha = Boolean(i); }
		
		/**
		 * @private
		 */
		override protected function extend(index:uint):void 
		{
			for (var i:int = length; i <= index; i++) 
			{				
				var newColor:Color = new Color();
				newColor.random(randomize_red,randomize_green,randomize_blue,randomize_alpha);
				palette.push(newColor);	
			}
		}
	}
	
}