﻿package com.kraftner.geom 
{
	import com.kraftner.communication.ControllerConnection;
	/**
	 * @internal
	 * DynamicPaletteHueCircle.as
	 * Copyright (c) 2008 Thomas Kräftner
	 * 
	 * Visit http://blog.kraftner.com for documentation, updates and more free code.
	 */
	
	/**
	* Circles through a 360 degree Hue Circle based on a start color.
	* <p>Keep in mind that this does NOT mean that it circles through ALL available RGB Colors.</p>
	* @author Thomas Kräftner
	*/	
	public class DynamicPaletteHueCircle extends Palette
	{
		private var stepWithDegree:Number;
		
		/**
		 * Constructor method
		 * @param	startColor Color object from which to start the Hue Circle
		 * @param	stepWithDegree Number of degrees in the Hue Circle Colors are apart from each other. This represents how fast the color changes.
		 */
		public function DynamicPaletteHueCircle(startColor:Color, stepWithDegree:Number):void
		{
			this.stepWithDegree = stepWithDegree;
			palette.push(startColor);
			
			var controllerConnection:ControllerConnection = ControllerConnection.getInstance();
			controllerConnection.addRange("stepWithDegree", setStepWithDegree, -360, 360, stepWithDegree);
		}
		
		private function setStepWithDegree(i:Number):void { stepWithDegree=i; }
		
		/**
		 * @private
		 */
		override protected function extend(index:uint):void 
		{
			for (var i:int = length; i <= index; i++) 
			{
				var newColor:Color = palette[i-1].clone();
				newColor.hue -= stepWithDegree
				palette.push(newColor);
			}
		}
	}
	
}