﻿package com.kraftner.communication 
{
	import flash.events.StatusEvent;
	import flash.net.LocalConnection;
	
	/**
	 * @internal
	 * ControllerConnection.as
	 * Copyright (c) 2008 Thomas Kräftner
	 * 
	 * Visit http://blog.kraftner.com for documentation, updates and more free code.
	 */
	
	 /**
	 * Handles the LocalConnections to request new controls and handles and dispatches changes from the Controller Application.
	 * @author Thomas Kräftner
	 */
	
	public class ControllerConnection 
	{
		private static var _instance:ControllerConnection;
			
		private const controllerConnectionName:String = "controller";
		private var controllerConnection:LocalConnection;
		
		private static const BUTTON:String = "addButton";
		private static const RANGE:String = "addRange";
		private static const CHOICE:String = "addChoice";
			
		private var functionReference:Vector.<Function> = new Vector.<Function>();
		
		/**
		 * Singleton constructor
		 * @param	pvt
		 */
		public function ControllerConnection(pvt:PrivateClass)
		{
			controllerConnection = new LocalConnection();
            controllerConnection.client = this;
			controllerConnection.addEventListener(StatusEvent.STATUS, statusEventHandler);
			try {
                controllerConnection.connect("JustLineOn");
            } catch (error:ArgumentError) {
                trace("Can't connect...the connection name is already being used by another SWF");
            }
		}
		
		/**
		 * Singleton constructor method
		 * @return
		 */
		public static function getInstance():ControllerConnection
		{
			if (ControllerConnection._instance == null)
			{
				ControllerConnection._instance = new ControllerConnection(new PrivateClass());
			}
			return ControllerConnection._instance;
		}
		
		/**
		 * Asks the controller to reset the Controller Application
		 */
		public function init():void
		{
			controllerConnection.send(controllerConnectionName, "init");
		}
		
		/**
		 * Asks the controller to create a Button
		 * @param	label Button-Label
		 * @param	handlerFunction Function that handles clicks on the button.
		 */
		public function addButton(label:String, handlerFunction:Function):void
		{
			var reference:uint = functionReference.push(handlerFunction) - 1;
			controllerConnection.send(controllerConnectionName, ControllerConnection.BUTTON, label, reference);
		}
		
		/**
		 * Asks the controller to create a Knob to control a range.
		 * @param	label Knob-Label
		 * @param	handlerFunction Function that handles changes of the knob. The function needs to accept a Number as argument: function foo(i:Number):void
		 * @param	minimum Minimum value of the range
		 * @param	maximum Maximum value of the range
		 * @param	value Value the Knob will be set to when created. Default value is the minimum value.
		 */
		public function addRange(label:String="", handlerFunction:Function=undefined, minimum:Number=0, maximum:Number=100, value:Number=NaN):void
		{
			var reference:uint = functionReference.push(handlerFunction)-1;
			controllerConnection.send(controllerConnectionName, ControllerConnection.RANGE, label, reference, minimum, maximum, value);
		}
		
		/**
		 * Asks the controller to create a Rotary Selector to switch between choices.
		 * @param	label Rotary Selector Label
		 * @param	handlerFunction Function that handles changes of the Rotary Selector. The function needs to accept a uint as argument: function foo(i:uint):void
		 * @param	numChoices Number of choices.
		 * @param	value Value the Rotary Selector will be set to when created.
		 */
		public function addChoice(label:String="", handlerFunction:Function=undefined, numChoices:uint=2, value:uint=0):void
		{
			var reference:uint = functionReference.push(handlerFunction)-1;
			controllerConnection.send(controllerConnectionName, ControllerConnection.CHOICE, label, reference, numChoices,value);
		}
		
		/**
		 * Takes requests to change values and dispatches the corresponding Functions.
		 * @param	reference uint under which the callback Function is stored
		 * @param	p value to which to set the corresponding property
		 */
		public function update(reference:uint,p:Number=undefined):void
		{
			if (p || p==0)
			{
				functionReference[reference](p);
			}else{
				functionReference[reference]();
			}
		}
		
		/**
		 * Handles Error when controller is not running.
		 * @param	se
		 */
		private function statusEventHandler(se:StatusEvent) :void{
			trace(se);
		}
		
	}
	
}
class PrivateClass
{
	public function PrivateClass()
	{
	}
}