package  {
	
	import com.gskinner.utils.Rndm;
	import com.kraftner.communication.ControllerConnection;
	import com.kraftner.geom.Color;
	import com.kraftner.geom.DynamicPaletteHueCircle;
	import com.kraftner.geom.DynamicPaletteRandom;
	import com.kraftner.geom.Palette;
	import com.kraftner.geom.Palettes;
	import com.kraftner.geom.StaticPalette;
	import com.kraftner.justlineon.lineservers.*;
	import com.kraftner.justlineon.painters.*;
	import com.kraftner.justlineon.pointtransformers.*;
	import com.kraftner.net.SaveAs;
	import flash.display.LoaderInfo;
	import flash.display.Sprite;
	import flash.display.Stage;
	import flash.display.StageAlign;
	import flash.display.StageDisplayState;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.geom.Point;
	import flash.net.FileFilter;
	import flash.net.FileReference;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.utils.Timer;
	
	/**
	 * @internal
	 * JustLineOn.as
	 * Copyright (c) 2008 Thomas Krftner
	 * 
	 * Visit http://blog.kraftner.com for documentation, updates and more free code.
	 */
	
	/**
	 * This is the Main Class of the JustLineOn Application.
	 * @author Thomas Krftner
	 */
	public class JustLineOn extends flash.display.Sprite  {
		
		private var fr:FileReference;
		private var project:XMLList;
		
		private var lineServer:Vector.<LineServer>;
		private var drawTimer:Timer = new Timer(10, 0);
		private var runs:Number = 1;
		
		private static var _this:Sprite;
		
		private static var doDump:Boolean = true;
		private static var _bmpMulti:Number = 4;
		
		/**
		 * Define a path to a Project XML that is automatically loaded on Application Startup.
		 */
		public var path:String;
		
		public function JustLineOn(p:String=null)
		{
			if (p) path = p;
			if (LoaderInfo(this.root.loaderInfo).parameters.p) path = LoaderInfo(this.root.loaderInfo).parameters.p;
			if (stage) onStage();
			else {
				addEventListener(Event.ADDED_TO_STAGE, onStage);
				addEventListener(Event.REMOVED_FROM_STAGE, destroy);
			}
		}
		
		private function onStage(e:Event = null):void {
			JustLineOn._this = this;
			
			_this.stage.scaleMode = StageScaleMode.NO_SCALE;
			_this.stage.align = StageAlign.TOP_LEFT;
			drawTimer.addEventListener(TimerEvent.TIMER, step);	
			
			fr = new FileReference();
			fr.addEventListener(Event.SELECT, onSelect);
			fr.addEventListener(Event.COMPLETE, onComplete);
			init();
			
			if(path){
				var loader:URLLoader = new URLLoader();
				var request:URLRequest = new URLRequest(path);
				loader.load(request);
				loader.addEventListener(Event.COMPLETE, onComplete);
			}else{
				selectProject();
			}
		}
		
		private function init():void {
			var controllerConnection:ControllerConnection = ControllerConnection.getInstance();
			controllerConnection.init();
			controllerConnection.addButton("load Project", selectProject);
			controllerConnection.addButton("toggle running", toggleDrawTimer);
			controllerConnection.addButton("restart", init);
			controllerConnection.addRange("runs / sec", setTimer, 10, 2000, drawTimer.delay);
			controllerConnection.addRange("steps / run", setRuns, 1, 2000, runs);
			controllerConnection.addButton("dump to Bitmap", dump);
			controllerConnection.addButton("save as PNG", SavePNG);
			controllerConnection.addButton("save as JPG", SaveJPG);
			controllerConnection.addChoice("doDump", setDoDump, 2, uint(doDump));
			
			destroy();
			
			_this.stage.addEventListener(KeyboardEvent.KEY_DOWN, checkKeys);
			lineServer = new Vector.<LineServer>();
			parseProject(project);			
		}
		
		private function destroy(e:Event = null):void {
			_this.stage.removeEventListener(KeyboardEvent.KEY_DOWN, checkKeys);
			drawTimer.reset();
			if (lineServer != null)
			{
				for (var i:int = 0; i < lineServer.length; i++) 
				{
				lineServer[i].destroy();
				removeChild(lineServer[i]);
				}
				lineServer = null;
			}
		}
		
		private function step(e:TimerEvent):void
		{
			for (var i:int = 0; i < lineServer.length; i++) 
			{
				if(lineServer[i].isAlive){
					for (var j:int = 0; j < runs; j++) 
					{
						var killme:Boolean = lineServer[i].step();
						if (killme)
						{
							/*If killme would be final this should be used.
							BUT this isn't recomended as it destroys the toggle running functionality and
							all Lineservers like the PathPlayer that disable themselves while loading.
							*/
							//removeChild(lineServer[i]);
							//lineServer.splice(0,1);
						}
					}
				}
			}
		}
		
		private function selectProject():void
		{
			var filter:FileFilter =  new FileFilter("JustLineOn Projects (*.xml)", "*.xml");
			fr.browse(new Array(filter));
		}
		
		private function onSelect(e:Event):void
		{
			fr.load();
		}
		
		private function onComplete(e:Event):void
		{
			var projectXML:XML = new XML(e.target.data);
			trace("-----\nnow running: '" + projectXML.title[0] + "' by '" + projectXML.author[0] + "' \n" + projectXML.description[0] + "\n-----");
			project = projectXML.project[0].child("lineserver");
			init();
			
			graphics.clear();
			if (projectXML.bgcolor[0]) graphics.beginFill(projectXML.bgcolor[0]);
			else graphics.beginFill(0x000000);
			graphics.drawRect(0, 0, width, height);
			graphics.endFill();
			drawTimer.start();
		}
		
		private function parseProject(list:XMLList):void {
            var item:XML;
            for each(item in list) {
				var lineserver:String;
				lineserver = item.attribute("type");
				var Server:LineServer;
				var checkChildren:Boolean = true;
				switch (lineserver) 
				{
					case "AlwaysTurn":
						var length:Number = item.attribute("length").toString() ? item.attribute("length").toString() : 50;
						var lengthMulti:Number = item.attribute("lengthMulti").toString() ? item.attribute("lengthMulti").toString() : 0.94;
						var lengthAdd:Number = item.attribute("lengthAdd").toString() ? item.attribute("lengthAdd").toString() : 0;
						var angleDegreeMin:Number = item.attribute("angleDegreeMin").toString() ? item.attribute("angleDegreeMin").toString() :0;
						var angleDegreeMax:Number = item.attribute("angleDegreeMax").toString() ? item.attribute("angleDegreeMax").toString() :0;
						var away:Number = item.attribute("away").toString() ? item.attribute("away").toString() : JustLineOn.width/2;
						var breakOutChance:Number = item.attribute("breakOutChance").toString() ? item.attribute("breakOutChance").toString() : 0;
						var randomAbort:Number = item.attribute("randomAbort").toString() ? item.attribute("randomAbort").toString() : 0;
						Server = new AlwaysTurn(length,lengthMulti,lengthAdd,angleDegreeMin,angleDegreeMax,away,breakOutChance,randomAbort);
					break;
					case "AlwaysTurnImplosion":
						length = item.attribute("length").toString() ? item.attribute("length").toString() : 50;
						lengthMulti = item.attribute("lengthMulti").toString() ? item.attribute("lengthMulti").toString() : 0.94;
						lengthAdd = item.attribute("lengthAdd").toString() ? item.attribute("lengthAdd").toString() : 0;
						angleDegreeMin = item.attribute("angleDegreeMin").toString() ? item.attribute("angleDegreeMin").toString() :0;
						angleDegreeMax = item.attribute("angleDegreeMax").toString() ? item.attribute("angleDegreeMax").toString() :0;
						away = item.attribute("away").toString() ? item.attribute("away").toString() : 20;
						var breakInChance:Number = item.attribute("breakInChance").toString() ? item.attribute("breakInChance").toString() :0;
						randomAbort = item.attribute("randomAbort").toString() ? item.attribute("randomAbort").toString() : 0;
						Server = new AlwaysTurnImplosion(length,lengthMulti,lengthAdd,angleDegreeMin,angleDegreeMax,away,breakInChance,randomAbort);
					break;
					case "CircularExplosion":
						length = item.attribute("length").toString() ? item.attribute("length").toString() : 50;
						angleDegreeMin = item.attribute("angleDegreeMin").toString() ? item.attribute("angleDegreeMin").toString() :0;
						angleDegreeMax = item.attribute("angleDegreeMax").toString() ? item.attribute("angleDegreeMax").toString() :0;
						away = item.attribute("away").toString() ? item.attribute("away").toString() : JustLineOn.width/2;
						var awaySub:Number = item.attribute("awaySub").toString() ? item.attribute("awaySub").toString() : 0.02;
						breakOutChance = item.attribute("breakOutChance").toString() ? item.attribute("breakOutChance").toString() : 0;
						randomAbort = item.attribute("randomAbort").toString() ? item.attribute("randomAbort").toString() : 0;
						var circleStepWidthDegree:Number = item.attribute("circleStepWidthDegree").toString() ? item.attribute("circleStepWidthDegree").toString() : 1;
						Server = new CircularExplosion(length,angleDegreeMin,angleDegreeMax,away,awaySub,breakOutChance,randomAbort,circleStepWidthDegree);
					break;
					case "CircularImplosion":
						length = item.attribute("length").toString() ? item.attribute("length").toString() : 20;
						angleDegreeMin = item.attribute("angleDegreeMin").toString() ? item.attribute("angleDegreeMin").toString() :0;
						angleDegreeMax = item.attribute("angleDegreeMax").toString() ? item.attribute("angleDegreeMax").toString() :0;
						var awayStart:Number = item.attribute("awayStart").toString() ? item.attribute("awayStart").toString() : JustLineOn.width/2;
						var awayEnd:Number = item.attribute("awayEnd").toString() ? item.attribute("awayEnd").toString() : 20;
						awaySub = item.attribute("awaySub").toString() ? item.attribute("awaySub").toString() : 0.02;
						breakInChance = item.attribute("breakInChance").toString() ? item.attribute("breakInChance").toString() :0;
						randomAbort = item.attribute("randomAbort").toString() ? item.attribute("randomAbort").toString() : 0;
						circleStepWidthDegree = item.attribute("circleStepWidthDegree").toString() ? item.attribute("circleStepWidthDegree").toString() : 1;
						var restart:Boolean = item.attribute("restart").toString() && item.attribute("restart").toString()!="false" ? item.attribute("restart").toString() : false;
						Server = new CircularImplosion(length,angleDegreeMin,angleDegreeMax,awayStart,awayEnd,awaySub,breakInChance,randomAbort,circleStepWidthDegree,restart);
					break;
					case "LineServer":
						Server = new LineServer();
					break;
					case "PathPlayer":
						var path:String = item.attribute("path").toString() ? item.attribute("path").toString() : "path.txt";
						restart = item.attribute("restart").toString() && item.attribute("restart").toString()!="false" ? item.attribute("restart").toString() : false;
						Server = new PathPlayer(path,restart);
					break;
					default:
					throw new Error("Error parsing Project XML. Unknown LineServer type.'" + lineserver + "'");
					checkChildren = false;
					break;
				}
				if(checkChildren){
				addPainter(item.child("painter"), Server);
				addPointTransformer(item.child("pointtransformer"), Server);
				lineServer.push(Server);
				
				}
            }
			for (var j:int = 0; j < lineServer.length; j++) 
			{
				addChild(lineServer[j]);
			}

        }
		
		private function addPainter(list:XMLList,Server:LineServer):void
		{
			var item:XML;
            for each(item in list) {
				var painter:String;
				painter = item.attribute("type");
				var newPainter:Painter;
				var checkChildren:Boolean = true;
				switch (painter) 
				{
					case "DotPainter":
						var chance:Number = item.attribute("chance").toString() ? item.attribute("chance").toString() : 1;
						var minwidthdivisor:Number = item.attribute("minwidthdivisor").toString() ? item.attribute("minwidthdivisor").toString() : 10;
						var maxwidthdivisor:Number = item.attribute("maxwidthdivisor").toString() ? item.attribute("maxwidthdivisor").toString() : 10;
						var border:Boolean = item.attribute("border").toString() && item.attribute("border").toString() != "false" ? item.attribute("jumpeach").toString() : false;
						var borderWidth:Number = item.attribute("borderWidth").toString() ? item.attribute("borderWidth").toString() : 0;
						newPainter=new DotPainter(chance,minwidthdivisor,maxwidthdivisor, border, borderWidth);
					break;
					case "EndpointPainter":
						var form:Number = item.attribute("form").toString() ? item.attribute("form").toString() : 0;
						chance = item.attribute("chance").toString() ? item.attribute("chance").toString() : 1;
						minwidthdivisor = item.attribute("minwidthdivisor").toString() ? item.attribute("minwidthdivisor").toString() : 10;
						maxwidthdivisor = item.attribute("maxwidthdivisor").toString() ? item.attribute("maxwidthdivisor").toString() : 10;
						border = item.attribute("border").toString() && item.attribute("border").toString() != "false" ? item.attribute("jumpeach").toString() : false;
						borderWidth = item.attribute("borderWidth").toString() ? item.attribute("borderWidth").toString() : 0;
						newPainter=new EndpointPainter(form, chance,minwidthdivisor,maxwidthdivisor, border, borderWidth);
					break;
					case "Painter":
						newPainter=new Painter();
					break;
					case "RibbonPainter":
						var multi:Number = item.attribute("multi").toString() ? item.attribute("multi").toString() : 1;
						var twirl:Boolean = item.attribute("twirl").toString() && item.attribute("twirl").toString()!="false" ? item.attribute("twirl").toString() : false;
						var jumpeach:Boolean = item.attribute("jumpeach").toString() && item.attribute("jumpeach").toString() != "false" ? item.attribute("jumpeach").toString() : false;
						minwidthdivisor = item.attribute("minwidthdivisor").toString() ? item.attribute("minwidthdivisor").toString() : 5;
						maxwidthdivisor = item.attribute("maxwidthdivisor").toString() ? item.attribute("maxwidthdivisor").toString() : 5;
						var maxJumpPerc:Number = item.attribute("maxJumpPerc").toString() ? item.attribute("maxJumpPerc").toString() : 0;
						border = item.attribute("border").toString() && item.attribute("border").toString() != "false" ? item.attribute("jumpeach").toString() : false;
						borderWidth = item.attribute("borderWidth").toString() ? item.attribute("borderWidth").toString() : 0;
						newPainter=new RibbonPainter(multi,twirl,jumpeach,minwidthdivisor,maxwidthdivisor,maxJumpPerc,border, borderWidth);
					break;
					default:
					throw new Error("Error parsing Project XML. Unknown Painter type.'" + painter + "'");
					checkChildren = false;
					break;
				}
				if (checkChildren)
				{
					Server.addPainter(newPainter);
					addPalette(item.child("palette"),newPainter);
				}
            }
		}
		
		private function addPalette(list:XMLList,painter:Painter):void
		{
			var item:XML;
            for each(item in list) {
				var palette:String;
				palette = item.attribute("type");
				var newPalette:Palette;
				switch (palette) 
				{
					case "preset":
						if (Palettes[item.attribute("name").toString()]) {
							newPalette = Palettes[item.attribute("name").toString()];
						}else{
							throw new Error("Error parsing Project XML. Unknown Preset-Palette.'" + item.attribute("name").toString() + "'");
						}
						
						painter.addPalette(newPalette);
					break;
					case "dynamicRandom":
						var red:Boolean = item.attribute("red").toString() && item.attribute("red").toString()!="false" ? item.attribute("red").toString() : true;
						var green:Boolean = item.attribute("green").toString() && item.attribute("green").toString()!="false" ? item.attribute("green").toString() : true;
						var blue:Boolean = item.attribute("blue").toString() && item.attribute("blue").toString()!="false" ? item.attribute("blue").toString() : true;
						var alpha:Boolean = item.attribute("alpha").toString() && item.attribute("alpha").toString()!="false" ? item.attribute("alpha").toString() : false;
						var fillWith:Number = item.attribute("fillWith").toString() ? item.attribute("fillWith").toString() : 0;
						newPalette = new DynamicPaletteRandom(red, green, blue, alpha, fillWith);
						painter.addPalette(newPalette);
					break;
					case "dynamicHueCircle":
						var red1:Number = item.attribute("red1").toString() ? item.attribute("red1").toString() : 0;
						var green1:Number = item.attribute("green1").toString() ? item.attribute("green1").toString() : 0;
						var blue1:Number = item.attribute("blue1").toString() ? item.attribute("blue1").toString() : 0;
						var alpha1:Number = item.attribute("alpha1").toString() ? item.attribute("alpha1").toString() : 1;
						var stepWithDegree:Number = item.attribute("stepWithDegree").toString() ? item.attribute("stepWithDegree").toString() : 1;
						newPalette = new DynamicPaletteHueCircle(new Color(red1, green1, blue1, alpha1), stepWithDegree);
						painter.addPalette(newPalette);
					break;
					case "static":
						newPalette = new StaticPalette();
						addColor(item.child("*"), StaticPalette(newPalette));
						painter.addPalette(newPalette);
					break;
					default:
					throw new Error("Error parsing Project XML. Unknown Palette type.'" + painter + "'");
					break;
				}
				var sortBy:String = item.attribute("sortBy").toString() ? item.attribute("sortBy").toString() : null;
				if (sortBy) {
					try {
						newPalette["sortBy"+sortBy]();
					}catch (e:ReferenceError) {
						throw new Error("Error parsing Project XML. Unknown Sorting method.'sortBy" + sortBy + "'");
					}
					
				}
            }
		}
		
		private function addColor(list:XMLList,palette:StaticPalette):void
		{
			var item:XML;
            for each(item in list) {
				if (item.name().localName == "color") {
					var red:Number = item.attribute("red").toString() ? item.attribute("red").toString() : 0;
					var green:Number = item.attribute("green").toString() ? item.attribute("green").toString() : 0;
					var blue:Number = item.attribute("blue").toString() ? item.attribute("blue").toString() : 0;
					var alpha:Number = item.attribute("alpha").toString() ? item.attribute("alpha").toString() : 1;
					palette.addColor(new Color(red, green, blue, alpha));	
				}else if (item.name().localName == "gradient") {
					var steps:Number = item.attribute("steps").toString() ? item.attribute("steps").toString() : 10;
					var colors:XMLList = item.child("color");
					var item2:XML;
					var gradientColors:Vector.<Color> = new Vector.<Color>();
					for each(item2 in colors) {
						var red2:Number = item2.attribute("red").toString() ? item2.attribute("red").toString() : 0;
						var green2:Number = item2.attribute("green").toString() ? item2.attribute("green").toString() : 0;
						var blue2:Number = item2.attribute("blue").toString() ? item2.attribute("blue").toString() : 0;
						var alpha2:Number = item2.attribute("alpha").toString() ? item2.attribute("alpha").toString() : 1;
						gradientColors.push(new Color(red2, green2, blue2, alpha2));
					}
					for (var i:int = 0; i < gradientColors.length-1; i++) 
					{
						palette.addGradient(gradientColors[i], gradientColors[i + 1],Math.floor(steps/gradientColors.length));
					}
				}else {
					throw new Error("Error parsing Project XML. Unknown Element.'" + item.name().localName + "'");
				}
            }
		}
		
		private function addPointTransformer(list:XMLList,Server:LineServer):void
		{
			var item:XML;
            for each(item in list) {
				var pointtransformer:String;
				pointtransformer = item.attribute("type");
				switch (pointtransformer) 
				{
					case "PointPlusRandom":
						var x1:Number = item.attribute("x1").toString() ? item.attribute("x1").toString() : -1;
						var x2:Number = item.attribute("x2").toString() ? item.attribute("x2").toString() : 1;
						var y1:Number = item.attribute("y1").toString() ? item.attribute("y1").toString() : -1;
						var y2:Number = item.attribute("y2").toString() ? item.attribute("y2").toString() : 1;
						Server.addPointTransformer(new PointPlusRandom(x1, x2, y1, y2));
					break;
				}
            }
		}
		
		public function toggleDrawTimer():void
		{			
			if (drawTimer.running)
				{
				drawTimer.stop();
			}else{
				drawTimer.start();
			}
		}
		
		private function setTimer(i:Number):void
		{
			drawTimer.delay = i;
		}
		
		private function setRuns(i:Number):void
		{
			runs = i;
		}
		
		public function dump():void
		{
			for (var i:int = 0; i < lineServer.length; i++) 
			{
				lineServer[i].dump();
			}	
		}
		
		private function SavePNG():void {
			dump();
			SaveAs.PNG(this,"JustLineOn");
		}
		
		private function SaveJPG():void {
			dump();
			SaveAs.JPG(this, "JustLineOn");
		}
		
		private function setDoDump(i:Number):void {
			doDump = Boolean(i);
		}
		
		private function toggleFullscreen():void
		{			
			if (_this.stage.displayState == StageDisplayState.FULL_SCREEN)
				{
				_this.stage.displayState = StageDisplayState.NORMAL;
			}else{
				_this.stage.displayState = StageDisplayState.FULL_SCREEN;
			}
		}
		
		private function checkKeys(e:KeyboardEvent):void 
		{
			switch(e.keyCode)
			{
				case 20:
				toggleDrawTimer();
				break;
				case 32:
				init();
				break;
				case 82:
				init();
				toggleDrawTimer();
				break;
				case 80:
				SavePNG();
				break;
				case 74:
				SaveJPG();
				break;
				case 79:
				selectProject();
				break;
				case 70:
				toggleFullscreen();
				break;
				case 107:
				if (drawTimer.delay > 10) drawTimer.delay -= 1;
				if (runs<1000) runs+=10;
				break;
				case 109:
				if (drawTimer.delay < 2000) drawTimer.delay += 1;
				if (runs>2) runs-=10;
				break;
			}
		}
		
		/**
		 * Center of the Stage
		 */
		public static function get center():Point { return new Point(JustLineOn._this.stage.stageWidth/2,JustLineOn._this.stage.stageHeight/2); }
		/**
		 * Width of the Stage
		 */
		public static function get width():Number { return JustLineOn._this.stage.stageWidth; }
		/**
		 * Height of the Stage
		 */
		public static function get height():Number { return JustLineOn._this.stage.stageHeight; }
		/**
		 * Shows if bitmap caching is on/off. Should only be off for Vectordata-Export.
		 */
		public static function get dump():Boolean { return JustLineOn.doDump; }
		/**
		 * Sets the mulitplier vor the bitmap caching. If the Stage is 500x500 a value of 2 renders and exports in 1000x1000
		 */
		public static function get bmpMulti():Number { return JustLineOn._bmpMulti; }
	}
}